/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ModEntriesConfigs;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5797;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class ResourcesUtils {
    private static final JsonObject DUMMY_BLOCKSTATE = new JsonObject();
    protected static final String RES_CHARS = "[a-z,A-Z,\\-,_./]*";
    protected static final Pattern RES_PATTERN;

    public static <B extends class_2248, T extends BlockType> void generateStandardBlockModels(class_3300 manager, DynClientResourcesGenerator d, Map<T, B> blocks, T baseType, BlockTypeResTransformer<T> modelTransformer, BlockTypeResTransformer<T> blockStateTransformer) {
        if (blocks.isEmpty()) {
            return;
        }
        Map.Entry first = (Map.Entry)blocks.entrySet().stream().findFirst().get();
        class_2248 oakBlock = BlockType.changeBlockType((class_2248)((class_2248)first.getValue()), (BlockType)((BlockType)first.getKey()), baseType);
        if (oakBlock == null) {
            EveryCompat.LOGGER.error("Failed to generate some block assets");
            return;
        }
        class_2960 oakId = Utils.getID((class_2248)oakBlock);
        HashSet<String> modelsLoc = new HashSet<String>();
        try {
            StaticResource oakBlockstate = StaticResource.getOrFail((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(oakId));
            JsonObject insideBlockstates = RPUtils.deserializeJson((InputStream)new ByteArrayInputStream(oakBlockstate.data));
            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)insideBlockstates, s -> s.equals("model")));
            List<StaticResource> oakBlockModels = ResourcesUtils.gatherNonVanillaModels(manager, modelsLoc);
            blocks.forEach((blockType, block) -> {
                class_2960 blockId = Utils.getID((class_2248)block);
                try {
                    StaticResource newBlockState = blockStateTransformer.transform(oakBlockstate, blockId, blockType);
                    Preconditions.checkArgument((newBlockState.location != oakBlockstate.location ? 1 : 0) != 0, (Object)("ids cant be the same: " + String.valueOf(newBlockState.location)));
                    d.addResourceIfNotPresent(manager, newBlockState);
                    for (StaticResource model : oakBlockModels) {
                        try {
                            StaticResource newModel = modelTransformer.transform(model, blockId, blockType);
                            Preconditions.checkArgument((newModel.location != model.location ? 1 : 0) != 0, (Object)("ids cant be the same: " + String.valueOf(newModel.location)));
                            d.addResourceIfNotPresent(manager, newModel);
                        }
                        catch (Exception exception) {
                            EveryCompat.LOGGER.error("Failed to add {} model json file:", block, (Object)exception);
                        }
                    }
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to add {} blockstate json file:", block, (Object)e);
                }
            });
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not find blockstate definition for {}", (Object)oakBlock);
        }
    }

    private static List<StaticResource> gatherNonVanillaModels(class_3300 manager, Set<String> modelsLoc) {
        ArrayList<StaticResource> models = new ArrayList<StaticResource>();
        for (String m : modelsLoc) {
            StaticResource model;
            class_2960 modelRes = new class_2960(m);
            if (modelRes.method_12836().equals("minecraft") || (model = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.MODELS.getPath(m))) == null) continue;
            models.add(model);
        }
        return models;
    }

    public static <I extends class_1792, T extends BlockType> void generateStandardItemModels(class_3300 manager, DynClientResourcesGenerator d, Map<T, I> items, T baseType, BlockTypeResTransformer<T> itemModelTransformer) {
        if (items.isEmpty()) {
            return;
        }
        Map.Entry first = (Map.Entry)items.entrySet().stream().findFirst().get();
        class_1792 oakItem = BlockType.changeItemType((class_1792)((class_1792)first.getValue()), (BlockType)((BlockType)first.getKey()), baseType);
        if (oakItem == null) {
            EveryCompat.LOGGER.error("Failed to generate some item assets");
            return;
        }
        String baseItemName = baseType.getTypeName();
        HashSet<String> modelsLoc = new HashSet<String>();
        try {
            String parent;
            StaticResource oakItemModel = StaticResource.getOrFail((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Utils.getID((class_1792)oakItem)));
            JsonObject json = RPUtils.deserializeJson((InputStream)new ByteArrayInputStream(oakItemModel.data));
            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)json, s -> s.equals("model") || s.equals("parent")));
            if (json.has("parent") && (parent = json.get("parent").getAsString()).contains("item/generated")) {
                itemModelTransformer.replaceItemType(baseItemName);
            }
            items.forEach((w, b) -> {
                class_2960 id = Utils.getID((class_1792)b);
                try {
                    StaticResource newRes = itemModelTransformer.transform(oakItemModel, id, w);
                    Preconditions.checkArgument((newRes.location != oakItemModel.location ? 1 : 0) != 0, (Object)("ids cant be the same: " + String.valueOf(newRes.location)));
                    d.addResourceIfNotPresent(manager, newRes);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to add {} item model json file:", b, (Object)e);
                }
            });
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not find item model for {}", (Object)oakItem);
        }
        List<StaticResource> oakItemModels = ResourcesUtils.gatherNonVanillaModels(manager, modelsLoc);
        items.forEach((w, b) -> {
            class_2960 id = Utils.getID((class_1792)b);
            for (StaticResource model : oakItemModels) {
                try {
                    StaticResource newModel = itemModelTransformer.transform(model, id, w);
                    assert (newModel.location != model.location) : "ids cant be the same";
                    d.addResourceIfNotPresent(manager, newModel);
                }
                catch (Exception exception) {
                    EveryCompat.LOGGER.error("Failed to add {} model json file:", b, (Object)exception);
                }
            }
        });
    }

    @NotNull
    public static <T extends BlockType> BlockTypeResTransformer<T> addBuiltinModelTransformer(BlockTypeResTransformer<T> transformer, T baseType) {
        String oldTypeName = baseType.getTypeName();
        transformer.setIDModifier((text, id, w) -> BlockTypeResTransformer.replaceFullGenericType((String)text, (BlockType)w, (class_2960)id, (String)oldTypeName, null, (int)2));
        if (baseType instanceof LeavesType) {
            LeavesType leavesType = (LeavesType)baseType;
            transformer.replaceLeavesTextures(leavesType);
            WoodType woodT = leavesType.getWoodType();
            if (woodT != null) {
                transformer.replaceWoodTextures(woodT);
            }
        } else if (baseType instanceof WoodType) {
            WoodType woodType = (WoodType)baseType;
            transformer.replaceWoodTextures(woodType);
        }
        transformer.replaceGenericType(oldTypeName, "block");
        return transformer;
    }

    public static <B extends class_2248, T extends BlockType> void addBlockResources(class_3300 manager, DynamicResourcePack pack, Map<T, B> blocks, BlockTypeResTransformer<T> modifier, class_2960 ... jsonsLocations) {
        List<StaticResource> original = Arrays.stream(jsonsLocations).map(s -> StaticResource.getOrLog((class_3300)manager, (class_2960)s)).toList();
        blocks.forEach((wood, value) -> {
            if (ModEntriesConfigs.isEntryEnabled(wood, value)) {
                for (StaticResource res : original) {
                    try {
                        StaticResource newRes = modifier.transform(res, Utils.getID((class_2248)value), wood);
                        Preconditions.checkArgument((newRes.location != res.location ? 1 : 0) != 0, (Object)("ids cant be the same: " + String.valueOf(newRes.location)));
                        pack.addResource(newRes);
                    }
                    catch (Exception e) {
                        if (res == null) continue;
                        EveryCompat.LOGGER.error("Failed to generate json resource from {}", (Object)res.location);
                    }
                }
            }
        });
    }

    public static void addLeavesRecipes(String modId, class_3300 manager, DynamicDataPack pack, Map<LeavesType, class_1792> blocks, String oakRecipe) {
        ResourcesUtils.addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, LeavesTypeRegistry.OAK_TYPE);
    }

    public static <B extends class_1792> void addWoodRecipes(String modId, class_3300 manager, DynamicDataPack pack, Map<WoodType, B> blocks, String oakRecipe) {
        ResourcesUtils.addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, WoodTypeRegistry.OAK_TYPE);
    }

    public static <B extends class_1792, T extends BlockType> void addBlocksRecipes(String modId, class_3300 manager, DynamicDataPack pack, Map<T, B> blocks, String oakRecipe, T fromType) {
        ResourcesUtils.addBlocksRecipes(manager, pack, blocks, new class_2960(modId, oakRecipe), fromType, 0);
    }

    public static <B extends class_1792, T extends BlockType> void addBlocksRecipes(class_3300 manager, DynamicDataPack pack, Map<T, B> items, class_2960 oakRecipe, T fromType, int index) {
        IRecipeTemplate template = RPUtils.readRecipeAsTemplate((class_3300)manager, (class_2960)ResType.RECIPES.getPath(oakRecipe));
        items.forEach((w, i) -> {
            if (ModEntriesConfigs.isEntryEnabled(w, i)) {
                try {
                    String blockId = class_5797.method_36442((class_1935)i).toString();
                    String oakRecipePath = oakRecipe.method_12832();
                    String modifiedRecipe = oakRecipePath.substring(oakRecipePath.lastIndexOf("/") + 1).replace(fromType.getTypeName(), w.getTypeName());
                    String target = blockId.substring(blockId.lastIndexOf("/") + 1);
                    String newId = blockId.replace(target, modifiedRecipe);
                    class_2444 newR = !blockId.equals(newId) ? template.createSimilar(fromType, w, w.mainChild().method_8389(), newId) : template.createSimilar(fromType, w, w.mainChild().method_8389());
                    if (newR == null) {
                        return;
                    }
                    newR = ForgeHelper.addRecipeConditions((class_2444)newR, (List)template.getConditions());
                    pack.addRecipe(newR);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to generate recipe @ {} for {}: {}", (Object)oakRecipe, i, (Object)e.getMessage());
                }
            }
        });
    }

    public static <T extends BlockType> class_1856 convertIngredient(class_1856 ingredient, T originalMat, T destinationMat) {
        class_1856 newIng = ingredient;
        for (class_1799 in : ingredient.method_8105()) {
            class_1792 i;
            class_1792 it = in.method_7909();
            if (it == class_1802.field_8077 || (i = BlockType.changeItemType((class_1792)it, originalMat, destinationMat)) == null) continue;
            newIng = class_1856.method_8091((class_1935[])new class_1935[]{i});
            break;
        }
        return newIng;
    }

    public static String convertItemIDinText(String text, BlockType fromType, BlockType toType) {
        Matcher matcher = RES_PATTERN.matcher(text);
        return matcher.replaceAll(m -> {
            Optional item = class_7923.field_41178.method_17966(class_2960.method_12829((String)m.group(1)));
            return item.map(value -> {
                if (((class_1792)item.get()).toString().equals("shulker_box")) {
                    return "\"minecraft:shulker_box\"";
                }
                return "\"" + Utils.getID((class_1792)BlockType.changeItemType((class_1792)value, (BlockType)fromType, (BlockType)toType)).toString() + "\"";
            }).orElseGet(() -> m.group(0));
        });
    }

    static {
        DUMMY_BLOCKSTATE.addProperty("parent", "block/cube_all");
        JsonObject t = new JsonObject();
        t.addProperty("all", "everycomp:block/disabled");
        DUMMY_BLOCKSTATE.add("textures", (JsonElement)t);
        RES_PATTERN = Pattern.compile("\"([a-z,A-Z,\\-,_./]*:[a-z,A-Z,\\-,_./]*)\"");
    }
}

